<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('job_id', 'agency_id', 'slug', 'registe_number', 'name', 'uv', 'phone', 'email', 'password', 'remember_token', 'email_verified_at', 'status');
    protected $visible = array('job_id', 'agency_id', 'slug', 'registe_number', 'name', 'uv', 'phone', 'email', 'password', 'remember_token', 'email_verified_at', 'status');

    public function job()
    {
        return $this->belongsTo('App\Models\Job', 'job_id');
    }

    public function agency()
    {
        return $this->belongsTo('App\Models\Agency', 'agency_id');
    }

    public function transfers()
    {
        return $this->hasMany('App\Models\Transfer', 'user_id');
    }

    public function exchanges()
    {
        return $this->hasMany('App\Models\Exchange', 'user_id');
    }

    public function usersBox()
    {
        return $this->hasMany('App\Models\UserBox', 'user_id');
    }

    public function paymentsCommissions()
    {
        return $this->hasMany('App\Models\PaymentCommission', 'user_id');
    }

    public function commissions()
    {
        return $this->hasMany('App\Models\Commission', 'user_id');
    }

    public function adminCashStatements()
    {
        return $this->hasMany('App\Models\CashStatement', 'admin_id');
    }

    public function reloadsUV()
    {
        return $this->hasMany('App\Models\ReloadUV', 'user_id');
    }

    public function passwordresetRequests()
    {
        return $this->hasMany('App\Models\PasswordresetRequest', 'user_id');
    }

    public function resettedPasswords()
    {
        return $this->hasMany('App\Models\PasswordresetRequest', 'admin_id');
    }

    public function cashout()
    {
        return $this->hasMany('App\Models\Transfer', 'beneficiary_user_id');
    }

    public function reloads()
    {
        return $this->hasMany('App\Models\ReloadUV', 'reloader_id');
    }

    public function cashsStatementAudit()
    {
        return $this->hasMany('App\Models\CashStatement', 'auditor_user_id');
    }

    public function amountCashUsersCurrencies()
    {
        return $this->hasMany('App\Models\AmountCashUsersCurrencies', 'user_id');
    }

    public function beneficiasCashStatements()
    {
        return $this->hasMany('App\Models\CashStatement', 'beneficiary_user_id');
    }

    public function sendsCashStatements()
    {
        return $this->hasMany('App\Models\CashStatement', 'sender_user_id');
    }

    public function auditReports()
    {
        return $this->hasMany('App\Models\AuditReport', 'user_id');
    }

}